Option Strict Off
Option Explicit On
Friend Class frmRisoluzioneEqGrado2
	Inherits System.Windows.Forms.Form
#Region "Windows Form Designer generated code "
	Public Sub New()
		MyBase.New()
		If m_vb6FormDefInstance Is Nothing Then
			If m_InitializingDefInstance Then
				m_vb6FormDefInstance = Me
			Else
				Try 
					'For the start-up form, the first instance created is the default instance.
					If System.Reflection.Assembly.GetExecutingAssembly.EntryPoint.DeclaringType Is Me.GetType Then
						m_vb6FormDefInstance = Me
					End If
				Catch
				End Try
			End If
		End If
		'This call is required by the Windows Form Designer.
		InitializeComponent()
	End Sub
	'Form overrides dispose to clean up the component list.
	Protected Overloads Overrides Sub Dispose(ByVal Disposing As Boolean)
		If Disposing Then
			If Not components Is Nothing Then
				components.Dispose()
			End If
		End If
		MyBase.Dispose(Disposing)
	End Sub
	'Required by the Windows Form Designer
	Private components As System.ComponentModel.IContainer
    Public WithEvents cmdEsci As System.Windows.Forms.Button
    Public WithEvents cmdCalcola As System.Windows.Forms.Button
	Public WithEvents txtB As System.Windows.Forms.TextBox
	Public WithEvents txtC As System.Windows.Forms.TextBox
	Public WithEvents txtA As System.Windows.Forms.TextBox
	Public WithEvents lblRisultato As System.Windows.Forms.Label
	Public WithEvents Label4 As System.Windows.Forms.Label
	Public WithEvents Label3 As System.Windows.Forms.Label
	Public WithEvents Label2 As System.Windows.Forms.Label
	Public WithEvents Label1 As System.Windows.Forms.Label
    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.
	'Do not modify it using the code editor.
    Friend WithEvents ToolTip1 As System.Windows.Forms.ToolTip
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container()
        Me.cmdEsci = New System.Windows.Forms.Button()
        Me.cmdCalcola = New System.Windows.Forms.Button()
        Me.txtB = New System.Windows.Forms.TextBox()
        Me.txtC = New System.Windows.Forms.TextBox()
        Me.txtA = New System.Windows.Forms.TextBox()
        Me.lblRisultato = New System.Windows.Forms.Label()
        Me.Label4 = New System.Windows.Forms.Label()
        Me.Label3 = New System.Windows.Forms.Label()
        Me.Label2 = New System.Windows.Forms.Label()
        Me.Label1 = New System.Windows.Forms.Label()
        Me.ToolTip1 = New System.Windows.Forms.ToolTip(Me.components)
        Me.SuspendLayout()
        '
        'cmdEsci
        '
        Me.cmdEsci.BackColor = System.Drawing.SystemColors.Control
        Me.cmdEsci.Cursor = System.Windows.Forms.Cursors.Default
        Me.cmdEsci.DialogResult = System.Windows.Forms.DialogResult.Cancel
        Me.cmdEsci.Font = New System.Drawing.Font("Arial", 12.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.cmdEsci.ForeColor = System.Drawing.SystemColors.ControlText
        Me.cmdEsci.Location = New System.Drawing.Point(200, 192)
        Me.cmdEsci.Name = "cmdEsci"
        Me.cmdEsci.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.cmdEsci.Size = New System.Drawing.Size(153, 41)
        Me.cmdEsci.TabIndex = 9
        Me.cmdEsci.Text = "Esci"
        Me.ToolTip1.SetToolTip(Me.cmdEsci, "Esci")
        '
        'cmdCalcola
        '
        Me.cmdCalcola.BackColor = System.Drawing.SystemColors.Control
        Me.cmdCalcola.Cursor = System.Windows.Forms.Cursors.Default
        Me.cmdCalcola.Font = New System.Drawing.Font("Arial", 12.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.cmdCalcola.ForeColor = System.Drawing.SystemColors.ControlText
        Me.cmdCalcola.Location = New System.Drawing.Point(16, 192)
        Me.cmdCalcola.Name = "cmdCalcola"
        Me.cmdCalcola.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.cmdCalcola.Size = New System.Drawing.Size(153, 41)
        Me.cmdCalcola.TabIndex = 8
        Me.cmdCalcola.Text = "Calcola"
        Me.ToolTip1.SetToolTip(Me.cmdCalcola, "Calcola soluzione")
        '
        'txtB
        '
        Me.txtB.AcceptsReturn = True
        Me.txtB.AutoSize = False
        Me.txtB.BackColor = System.Drawing.SystemColors.Window
        Me.txtB.Cursor = System.Windows.Forms.Cursors.IBeam
        Me.txtB.Font = New System.Drawing.Font("Arial", 8.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.txtB.ForeColor = System.Drawing.SystemColors.WindowText
        Me.txtB.Location = New System.Drawing.Point(168, 56)
        Me.txtB.MaxLength = 0
        Me.txtB.Name = "txtB"
        Me.txtB.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.txtB.Size = New System.Drawing.Size(65, 27)
        Me.txtB.TabIndex = 5
        Me.txtB.Text = ""
        '
        'txtC
        '
        Me.txtC.AcceptsReturn = True
        Me.txtC.AutoSize = False
        Me.txtC.BackColor = System.Drawing.SystemColors.Window
        Me.txtC.Cursor = System.Windows.Forms.Cursors.IBeam
        Me.txtC.Font = New System.Drawing.Font("Arial", 8.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.txtC.ForeColor = System.Drawing.SystemColors.WindowText
        Me.txtC.Location = New System.Drawing.Point(296, 56)
        Me.txtC.MaxLength = 0
        Me.txtC.Name = "txtC"
        Me.txtC.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.txtC.Size = New System.Drawing.Size(65, 27)
        Me.txtC.TabIndex = 6
        Me.txtC.Text = ""
        '
        'txtA
        '
        Me.txtA.AcceptsReturn = True
        Me.txtA.AutoSize = False
        Me.txtA.BackColor = System.Drawing.SystemColors.Window
        Me.txtA.Cursor = System.Windows.Forms.Cursors.IBeam
        Me.txtA.Font = New System.Drawing.Font("Arial", 8.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.txtA.ForeColor = System.Drawing.SystemColors.WindowText
        Me.txtA.Location = New System.Drawing.Point(48, 56)
        Me.txtA.MaxLength = 0
        Me.txtA.Name = "txtA"
        Me.txtA.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.txtA.Size = New System.Drawing.Size(65, 27)
        Me.txtA.TabIndex = 4
        Me.txtA.Text = ""
        '
        'lblRisultato
        '
        Me.lblRisultato.BackColor = System.Drawing.SystemColors.Control
        Me.lblRisultato.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.lblRisultato.Cursor = System.Windows.Forms.Cursors.Default
        Me.lblRisultato.Font = New System.Drawing.Font("Arial", 8.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.lblRisultato.ForeColor = System.Drawing.SystemColors.ControlText
        Me.lblRisultato.Location = New System.Drawing.Point(32, 104)
        Me.lblRisultato.Name = "lblRisultato"
        Me.lblRisultato.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.lblRisultato.Size = New System.Drawing.Size(305, 73)
        Me.lblRisultato.TabIndex = 7
        '
        'Label4
        '
        Me.Label4.BackColor = System.Drawing.SystemColors.Control
        Me.Label4.Cursor = System.Windows.Forms.Cursors.Default
        Me.Label4.Font = New System.Drawing.Font("Arial", 12.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label4.ForeColor = System.Drawing.SystemColors.ControlText
        Me.Label4.Location = New System.Drawing.Point(264, 56)
        Me.Label4.Name = "Label4"
        Me.Label4.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.Label4.Size = New System.Drawing.Size(25, 17)
        Me.Label4.TabIndex = 3
        Me.Label4.Text = "c ="
        '
        'Label3
        '
        Me.Label3.BackColor = System.Drawing.SystemColors.Control
        Me.Label3.Cursor = System.Windows.Forms.Cursors.Default
        Me.Label3.Font = New System.Drawing.Font("Arial", 12.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label3.ForeColor = System.Drawing.SystemColors.ControlText
        Me.Label3.Location = New System.Drawing.Point(136, 56)
        Me.Label3.Name = "Label3"
        Me.Label3.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.Label3.Size = New System.Drawing.Size(25, 17)
        Me.Label3.TabIndex = 2
        Me.Label3.Text = "b ="
        '
        'Label2
        '
        Me.Label2.BackColor = System.Drawing.SystemColors.Control
        Me.Label2.Cursor = System.Windows.Forms.Cursors.Default
        Me.Label2.Font = New System.Drawing.Font("Arial", 12.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label2.ForeColor = System.Drawing.SystemColors.ControlText
        Me.Label2.Location = New System.Drawing.Point(16, 56)
        Me.Label2.Name = "Label2"
        Me.Label2.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.Label2.Size = New System.Drawing.Size(25, 17)
        Me.Label2.TabIndex = 1
        Me.Label2.Text = "a ="
        '
        'Label1
        '
        Me.Label1.BackColor = System.Drawing.SystemColors.Control
        Me.Label1.Cursor = System.Windows.Forms.Cursors.Default
        Me.Label1.Font = New System.Drawing.Font("Arial", 12.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label1.ForeColor = System.Drawing.SystemColors.ControlText
        Me.Label1.Location = New System.Drawing.Point(16, 0)
        Me.Label1.Name = "Label1"
        Me.Label1.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.Label1.Size = New System.Drawing.Size(338, 45)
        Me.Label1.TabIndex = 0
        Me.Label1.Text = "Risoluzione di una equazione di secondo grado: a x^2 + bx + c = 0"
        Me.Label1.TextAlign = System.Drawing.ContentAlignment.TopCenter
        '
        'frmRisoluzioneEqGrado2
        '
        Me.AcceptButton = Me.cmdCalcola
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.CancelButton = Me.cmdEsci
        Me.ClientSize = New System.Drawing.Size(375, 252)
        Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.cmdEsci, Me.cmdCalcola, Me.txtB, Me.txtC, Me.txtA, Me.lblRisultato, Me.Label4, Me.Label3, Me.Label2, Me.Label1})
        Me.Font = New System.Drawing.Font("Arial", 8.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Location = New System.Drawing.Point(338, 261)
        Me.Name = "frmRisoluzioneEqGrado2"
        Me.StartPosition = System.Windows.Forms.FormStartPosition.Manual
        Me.Text = "Risoluzione equazioni di secondo grado"
        Me.ResumeLayout(False)

    End Sub
#End Region 
#Region "Upgrade Support "
	Private Shared m_vb6FormDefInstance As frmRisoluzioneEqGrado2
	Private Shared m_InitializingDefInstance As Boolean
	Public Shared Property DefInstance() As frmRisoluzioneEqGrado2
		Get
			If m_vb6FormDefInstance Is Nothing OrElse m_vb6FormDefInstance.IsDisposed Then
				m_InitializingDefInstance = True
				m_vb6FormDefInstance = New frmRisoluzioneEqGrado2()
				m_InitializingDefInstance = False
			End If
			DefInstance = m_vb6FormDefInstance
		End Get
		Set
			m_vb6FormDefInstance = Value
		End Set
	End Property
#End Region 
	'Progetto Soluzioni di una equazione di II grado
	
	'Trova le soluzioni di una equazione di secondo grado
	'Si noti l'utilizzo della istruzione If...Then...ElseIF...Else...
	
	
	
	Private Sub cmdCalcola_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdCalcola.Click
        'Variabili per i coefficienti
        Dim a As Double
        Dim b As Double
		Dim c As Double
		
        'Si verifica che l'input sia numerico ed in caso contrario si emette segnalazione
        If IsNumeric(txtA.Text) Then
            If IsNumeric(txtB.Text) Then
                If IsNumeric(txtC.Text) Then
                    a = CDbl(txtA.Text)
                    b = CDbl(txtB.Text)
                    c = CDbl(txtC.Text)
                    'Si chiama la routine di calcolo delle soluzioni
                    lblRisultato.Text = strCalcolaSoluzione(a, b, c)
                Else
                    MessageBox.Show("Inserire un valore numerico per il coefficiente c", "Errore di validit")
                    txtC.Focus()
                End If
            Else
                Call MessageBox.Show("Inserire un valore numerico per il coefficiente b", "Errore di validit")
                txtB.Focus()
            End If
        Else
            Call MessageBox.Show("Inserire un valore numerico per il coefficiente a", "Errore di validit")
            txtA.Focus()
        End If
		
	End Sub
	
	Private Sub cmdEsci_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdEsci.Click
        Me.Close()
        End
		
	End Sub
	
	Private Function strCalcolaSoluzione(ByRef a As Double, ByRef b As Double, ByRef c As Double) As String
		'Riceve in input i coefficienti di un'equazione di grado minore o uguale a 2
		'e rende una stringa contenente le soluzioni

        'Se il coefficiente del termine di grado 2  zero si tratta di un'equazione di grado <= 1
        'altrimenti l'equazione  effettivamente di secondo grado
        If a <> 0 Then
            strCalcolaSoluzione = strRisolviGrado2(a, b, c)
        ElseIf b <> 0 Then
            strCalcolaSoluzione = strRisolviGrado1(b, c)
        Else
            If c = 0 Then
                strCalcolaSoluzione = "Infinite soluzioni"
            Else
                strCalcolaSoluzione = "Nessuna soluzione"
            End If
        End If
	End Function
	
	Private Function strRisolviGrado2(ByRef a As Double, ByRef b As Double, ByRef c As Double) As String
		'Riceve in input i coefficienti di un'equazione di grado 2 e rende una stringa
		'contenente le soluzioni
		
        'Variabili per le soluzioni ed il delta
        Dim delta As Double
		Dim x1 As Double
		Dim x2 As Double
		
        'Calcolo del delta
        delta = b * b - 4 * a * c

        'Test del delta e calcolo delle soluzioni
		If delta < 0 Then
			strRisolviGrado2 = "Nessuna soluzione"
		ElseIf delta = 0 Then 
			x1 = -b / (2 * a)
			strRisolviGrado2 = "Due soluzioni coincidenti: x = " & x1
		Else
			x1 = (-b + System.Math.Sqrt(delta)) / (2 * a)
			x2 = (-b - System.Math.Sqrt(delta)) / (2 * a)
			strRisolviGrado2 = "Due soluzioni:  " & "x1 = " & x1 & "     x2 = " & x2
		End If
		
	End Function
	
	Private Function strRisolviGrado1(ByRef b As Double, ByRef c As Double) As String
		'Riceve in input i coefficienti di un'equazione di grado 1 e rende una stringa
		'contenente la soluzione
		
		strRisolviGrado1 = "Una soluzione : x = " & -c / b
		
	End Function


End Class